/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImageTiledPanel
extends JPanel {
    private Image img;
    private Dimension size;
    private TexturePaint paint;

    public ImageTiledPanel(String img) {
        this(new ImageIcon(img).getImage());
    }

    public ImageTiledPanel(Image img) {
        this.img = img;
        this.size = new Dimension(img.getWidth(null), img.getHeight(null));
        this.setPreferredSize(this.size);
        this.setMinimumSize(this.size);
        this.setMaximumSize(this.size);
        this.setSize(this.size);
        this.setLayout(null);
    }

    public void paintComponent(Graphics g) {
        if (this.paint == null) {
            try {
                int height = this.img.getHeight(this);
                int width = this.img.getWidth(this);
                BufferedImage bim = (BufferedImage)this.createImage(width, height);
                Graphics2D bim_g2d = (Graphics2D)bim.getGraphics();
                bim_g2d.drawImage(this.img, 0, 0, Color.black, this);
                this.paint = new TexturePaint(bim, new Rectangle(0, 0, width, height));
            }
            catch (Exception height) {
                // empty catch block
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.paint != null) {
            g2d.setPaint(this.paint);
            g2d.fill(g2d.getClip());
        }
    }
}

