/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import gui.HCPComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import objects.lang.LanguageStrings;

public class HCPDateComboBox
extends HCPComboBox {
    private SimpleDateFormat dateFormat;
    private String selectedDate;

    public HCPDateComboBox() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+1"));
        this.selectedDate = this.dateFormat.format(Calendar.getInstance().getTime());
    }

    public HCPDateComboBox(TimeZone timeZone) {
        this.dateFormat.setTimeZone(timeZone);
        this.selectedDate = this.dateFormat.format(Calendar.getInstance().getTime());
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        if (dateFormat == null) {
            return;
        }
        this.dateFormat = dateFormat;
    }

    public void setSelectedLong(long item) {
        this.removeAllItems();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(item);
        this.selectedDate = this.dateFormat.format(calendar.getTime());
        this.addItem(this.selectedDate);
        super.setSelectedItem(this.selectedDate);
    }

    public void setSelectedItem(Object item) {
        this.removeAllItems();
        this.selectedDate = item.toString();
        this.addItem(item);
        super.setSelectedItem(item);
    }

    public long getSelectedDateLong() throws Exception {
        Calendar cc = Calendar.getInstance();
        cc.setTime(this.dateFormat.parse(this.selectedDate));
        cc.set(11, 12);
        return cc.getTimeInMillis();
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof MetalComboBoxUI) {
            cui = new MetalDateComboBoxUI();
        } else if (cui instanceof MotifComboBoxUI) {
            cui = new MotifDateComboBoxUI();
        } else if (cui instanceof WindowsComboBoxUI) {
            cui = new WindowsDateComboBoxUI();
        }
        this.setUI((ComboBoxUI)cui);
    }

    private class DatePopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        protected JComboBox comboBox;
        protected Calendar calendar;
        protected JPopupMenu popup;
        protected JLabel monthLabel;
        protected JPanel days = null;
        protected Color selectedBackground;
        protected Color selectedForeground;
        protected Color background;
        protected Color foreground;
        protected JList list = new JList();
        protected boolean mouseInside = false;
        private boolean hideNext = false;

        public DatePopup(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.calendar = Calendar.getInstance();
            this.calendar.set(11, 12);
            int yr = this.calendar.get(1);
            int mn = this.calendar.get(2);
            int dts = this.calendar.get(5);
            String dt = String.valueOf(dts) + "." + mn + "." + yr;
            comboBox.addItem(dt);
            comboBox.setSelectedItem(HCPDateComboBox.this.dateFormat.format(this.calendar.getTime()));
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.initializePopup();
        }

        public void show() {
            try {
                this.calendar.setTime(HCPDateComboBox.this.dateFormat.parse(this.comboBox.getSelectedItem().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updatePopup();
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        public MouseListener getMouseListener() {
            return this;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        public KeyListener getKeyListener() {
            return this;
        }

        public boolean isVisible() {
            return this.popup.isVisible();
        }

        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!this.comboBox.isEnabled()) {
                return;
            }
            if (this.comboBox.isEditable()) {
                this.comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this.comboBox.requestFocus();
            }
            this.togglePopup();
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
        }

        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.hideNext = this.mouseInside;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        private void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
                this.popup.requestFocus();
            }
            this.hideNext = false;
        }

        private JLabel createUpdateButton(final int field, final int amount) {
            final JLabel label = new JLabel();
            final EtchedBorder selectedBorder = new EtchedBorder();
            final EmptyBorder unselectedBorder = new EmptyBorder(selectedBorder.getBorderInsets(new JLabel()));
            label.setBorder(unselectedBorder);
            label.setForeground(this.foreground);
            label.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    DatePopup.this.calendar.add(field, amount);
                    DatePopup.this.updatePopup();
                }

                public void mouseEntered(MouseEvent e) {
                    label.setBorder(selectedBorder);
                }

                public void mouseExited(MouseEvent e) {
                    label.setBorder(unselectedBorder);
                }
            });
            return label;
        }

        private void initializePopup() {
            JPanel header = new JPanel();
            header.setLayout(new BoxLayout(header, 0));
            header.setBackground(this.background);
            header.setOpaque(true);
            JLabel label = this.createUpdateButton(1, -1);
            label.setText("<<");
            label.setToolTipText("- " + LanguageStrings.getInstance().getStringByName("YEAR"));
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            label = this.createUpdateButton(2, -1);
            label.setText("<");
            label.setToolTipText("- " + LanguageStrings.getInstance().getStringByName("MONTH"));
            header.add(label);
            this.monthLabel = new JLabel("", 0);
            this.monthLabel.setForeground(this.foreground);
            header.add(Box.createHorizontalGlue());
            header.add(this.monthLabel);
            header.add(Box.createHorizontalGlue());
            label = this.createUpdateButton(2, 1);
            label.setText(">");
            label.setToolTipText("+ " + LanguageStrings.getInstance().getStringByName("MONTH"));
            header.add(label);
            label = this.createUpdateButton(1, 1);
            label.setText(">>");
            label.setToolTipText("+ " + LanguageStrings.getInstance().getStringByName("YEAR"));
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
            this.popup.add("North", header);
        }

        private void updatePopup() {
            this.monthLabel.setText(HCPDateComboBox.this.dateFormat.format(this.calendar.getTime()));
            if (this.days != null) {
                this.popup.remove(this.days);
            }
            this.days = new JPanel(new GridLayout(0, 7));
            this.days.setBackground(this.background);
            this.days.setOpaque(true);
            Calendar setupCalendar = HCPDateComboBox.this.dateFormat.getCalendar();
            setupCalendar.setTimeZone(TimeZone.getTimeZone("GMT+1"));
            setupCalendar.set(7, setupCalendar.getFirstDayOfWeek());
            int i = 0;
            while (i < 7) {
                int dayInt = setupCalendar.get(7);
                JLabel label = new JLabel();
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                if (dayInt == 1) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_SUN"));
                } else if (dayInt == 2) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_MON"));
                } else if (dayInt == 3) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_TUE"));
                } else if (dayInt == 4) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_WED"));
                } else if (dayInt == 5) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_THU"));
                } else if (dayInt == 6) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_FRI"));
                } else if (dayInt == 7) {
                    label.setText(LanguageStrings.getInstance().getStringByName("DAY_SAT"));
                }
                this.days.add(label);
                setupCalendar.roll(7, true);
                ++i;
            }
            setupCalendar = HCPDateComboBox.this.dateFormat.getCalendar();
            setupCalendar.setTimeZone(TimeZone.getTimeZone("GMT+1"));
            setupCalendar.set(5, 1);
            int first = setupCalendar.get(7);
            int i2 = 0;
            while (i2 < first - 1) {
                this.days.add(new JLabel(""));
                ++i2;
            }
            i2 = 1;
            while (i2 <= setupCalendar.getActualMaximum(5)) {
                final int day = i2;
                final JLabel label = new JLabel(String.valueOf(day));
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                if (day == this.calendar.get(5)) {
                    label.setBorder(BorderFactory.createEtchedBorder());
                }
                label.addMouseListener(new MouseListener(){

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseClicked(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                        label.setOpaque(false);
                        label.setBackground(DatePopup.this.background);
                        label.setForeground(DatePopup.this.foreground);
                        DatePopup.this.calendar.set(5, day);
                        DatePopup.this.comboBox.setSelectedItem(HCPDateComboBox.this.dateFormat.format(DatePopup.this.calendar.getTime()));
                        DatePopup.this.hide();
                        DatePopup.this.comboBox.requestFocus();
                    }

                    public void mouseEntered(MouseEvent e) {
                        label.setOpaque(true);
                        label.setBackground(DatePopup.this.selectedBackground);
                        label.setForeground(DatePopup.this.selectedForeground);
                    }

                    public void mouseExited(MouseEvent e) {
                        label.setOpaque(false);
                        label.setBackground(DatePopup.this.background);
                        label.setForeground(DatePopup.this.foreground);
                    }
                });
                this.days.add(label);
                ++i2;
            }
            this.popup.add("Center", this.days);
            this.popup.pack();
        }
    }

    private class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        private MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            HCPDateComboBox.this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            return new DatePopup(this.comboBox);
        }
    }

    private class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        private MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            HCPDateComboBox.this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            return new DatePopup(this.comboBox);
        }
    }

    private class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        private WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            HCPDateComboBox.this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            return new DatePopup(this.comboBox);
        }
    }
}

