/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.lipstikLF.delegate.LipstikComboBoxUI;
import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import gui.HCPCheckBox;
import gui.HCPComboBox;
import gui.HCPGreyButton;
import gui.HCPLabel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class HCPClockComboBox
extends HCPComboBox {
    private final SimpleDateFormat dateFormatSmall = new SimpleDateFormat("hh:mm:ss");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private static final Calendar calendar = dateFormat.getCalendar();

    public HCPClockComboBox() {
        dateFormat.setTimeZone(TimeZone.getDefault());
        this.dateFormatSmall.setTimeZone(TimeZone.getDefault());
    }

    public HCPClockComboBox(TimeZone timeZone) {
        dateFormat.setTimeZone(timeZone);
        this.dateFormatSmall.setTimeZone(timeZone);
    }

    public final SimpleDateFormat getDateFormat() {
        return dateFormat;
    }

    public void setSelectedItem(Object item) {
        this.removeAllItems();
        this.addItem(item);
        super.setSelectedItem(item);
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof LipstikComboBoxUI) {
            cui = new LipstikDateComboBoxUI();
        } else if (cui instanceof MetalComboBoxUI) {
            cui = new MetalDateComboBoxUI();
        } else if (cui instanceof MotifComboBoxUI) {
            cui = new MotifDateComboBoxUI();
        } else if (cui instanceof WindowsComboBoxUI) {
            cui = new WindowsDateComboBoxUI();
        }
        this.setUI((ComboBoxUI)cui);
    }

    private class DatePopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        private JComboBox comboBox;
        private JPopupMenu popup;
        protected final JList list = new JList();

        public DatePopup(JComboBox c) {
            this.comboBox = c;
            this.comboBox.setEditable(false);
            this.comboBox.setSelectedItem(dateFormat.format(calendar.getTime()));
            this.initializePopup();
        }

        private void togglePopup() {
            if (!this.comboBox.isEnabled()) {
                return;
            }
            if (this.isVisible()) {
                this.hide();
            } else {
                this.show();
                this.popup.requestFocus();
            }
        }

        public void show() {
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        public void hide() {
            this.popup.setVisible(false);
        }

        public boolean isVisible() {
            return this.popup.isVisible();
        }

        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        public JList getList() {
            return this.list;
        }

        public MouseListener getMouseListener() {
            return this;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        public KeyListener getKeyListener() {
            return this;
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.togglePopup();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        private void initializePopup() {
            final HCPCheckBox amCheck = new HCPCheckBox();
            final HCPCheckBox pmCheck = new HCPCheckBox();
            final ClockPane header = new ClockPane();
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.addPopupMenuListener(this);
            HCPGreyButton hourUp = new HCPGreyButton("+");
            hourUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (calendar.get(11) < 23) {
                        calendar.set(11, calendar.get(11) + 1);
                    } else {
                        calendar.set(11, 0);
                    }
                    header.repaint();
                    header.hour = calendar.get(11);
                }
            });
            HCPGreyButton hourDown = new HCPGreyButton("-");
            hourDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (calendar.get(11) > 0) {
                        calendar.set(11, calendar.get(11) - 1);
                    } else {
                        calendar.set(11, 23);
                    }
                    header.repaint();
                    header.hour = calendar.get(11);
                }
            });
            HCPGreyButton minUp = new HCPGreyButton("+");
            minUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (calendar.get(12) < 59) {
                        calendar.set(12, calendar.get(12) + 1);
                    } else {
                        calendar.set(12, 0);
                    }
                    header.repaint();
                    header.min = calendar.get(12);
                }
            });
            HCPGreyButton minDown = new HCPGreyButton("-");
            minDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (calendar.get(12) > 0) {
                        calendar.set(12, calendar.get(12) - 1);
                    } else {
                        calendar.set(12, 59);
                    }
                    header.repaint();
                    header.min = calendar.get(12);
                }
            });
            HCPGreyButton secUp = new HCPGreyButton("+");
            secUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (calendar.get(13) < 59) {
                        calendar.set(13, calendar.get(13) + 1);
                    } else {
                        calendar.set(13, 0);
                    }
                    header.repaint();
                    header.sec = calendar.get(13);
                }
            });
            HCPGreyButton secDown = new HCPGreyButton("-");
            secDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (calendar.get(13) > 0) {
                        calendar.set(13, calendar.get(13) - 1);
                    } else {
                        calendar.set(13, 59);
                    }
                    header.repaint();
                    header.sec = calendar.get(13);
                }
            });
            JPanel buttonPanel = new JPanel(new BorderLayout(5, 5));
            buttonPanel.setPreferredSize(new Dimension(100, 50));
            buttonPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new EmptyBorder(2, 2, 2, 2)));
            HCPGreyButton okButton = new HCPGreyButton("OK");
            okButton.setHorizontalAlignment(0);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (pmCheck.isSelected() && calendar.get(11) < 12) {
                        calendar.set(11, calendar.get(11) + 12);
                    }
                    if (amCheck.isSelected() && calendar.get(11) >= 12) {
                        calendar.set(11, calendar.get(11) - 12);
                    }
                    DatePopup.this.comboBox.setSelectedItem(dateFormat.format(calendar.getTime()));
                    DatePopup.this.togglePopup();
                }
            });
            buttonPanel.add("Center", okButton);
            JPanel arrowPanel = new JPanel();
            arrowPanel.setBorder(new SoftBevelBorder(0));
            arrowPanel.setLayout(new GridLayout(2, 3, 5, 5));
            arrowPanel.setIgnoreRepaint(true);
            arrowPanel.add(hourUp);
            arrowPanel.add(minUp);
            arrowPanel.add(secUp);
            arrowPanel.add(hourDown);
            arrowPanel.add(minDown);
            arrowPanel.add(secDown);
            buttonPanel.add("East", arrowPanel);
            amCheck.setSelected(calendar.get(11) < 12);
            pmCheck.setSelected(calendar.get(11) >= 12);
            ButtonGroup group = new ButtonGroup();
            group.add(amCheck);
            group.add(pmCheck);
            JPanel pomPanel = new JPanel();
            pomPanel.setBorder(new SoftBevelBorder(0));
            pomPanel.setLayout(new GridLayout(1, 4, 8, 8));
            pomPanel.setIgnoreRepaint(true);
            pomPanel.add(new HCPLabel("AM", 4));
            pomPanel.add(amCheck);
            pomPanel.add(new HCPLabel("PM", 4));
            pomPanel.add(pmCheck);
            this.popup.add("North", pomPanel);
            this.popup.add("Center", header);
            this.popup.add("South", buttonPanel);
            this.popup.pack();
        }

        class ClockPane
        extends JPanel {
            public int offset = 0;
            public int hour = HCPClockComboBox.access$0().get(10);
            public int min = HCPClockComboBox.access$0().get(12);
            public int sec = HCPClockComboBox.access$0().get(13);
            private final Font f = new Font("TimesRoman", 1, 15);
            private final Font ff = new Font("Courier New", 0, 11);

            public ClockPane() {
                this.setPreferredSize(new Dimension(200, 200));
                this.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        ClockPane.this.offset = 20;
                        if (e.getButton() == 3) {
                            ClockPane.this.min = ClockPane.this.getAngle(e.getX(), e.getY());
                            calendar.set(12, ClockPane.this.min);
                        } else if (e.getButton() == 1) {
                            ClockPane.this.hour = ClockPane.this.getAngle(e.getX(), e.getY());
                            ClockPane.this.hour /= 5;
                            if (ClockPane.this.hour >= 12) {
                                ClockPane.this.hour = 0;
                            }
                            calendar.set(10, ClockPane.this.hour);
                        } else if (e.getButton() == 2) {
                            ClockPane.this.sec = ClockPane.this.getAngle(e.getX(), e.getY());
                            calendar.set(13, ClockPane.this.sec);
                        }
                        ClockPane.this.repaint();
                        super.mousePressed(e);
                    }

                    public void mouseReleased(MouseEvent e) {
                        ClockPane.this.offset = 0;
                        ClockPane.this.repaint();
                        super.mouseReleased(e);
                    }
                });
                this.setToolTipText("Use mouse left button for hours,right for minutes and middle for seconds");
            }

            public int getAngle(int x, int y) {
                double angle = 0.0;
                if (x > 100 && y <= 100) {
                    angle = Math.atan((double)y / (double)(100 - (x -= 100)));
                    angle = Math.toDegrees(angle);
                } else if (x <= 100 && y <= 100) {
                    angle = Math.atan((double)(100 - y) / (double)(100 - x));
                    angle = Math.toDegrees(angle);
                    angle += 270.0;
                } else if (x <= 100 && y > 100) {
                    angle = Math.atan((double)(100 - (y -= 100)) / (double)x);
                    angle = Math.toDegrees(angle);
                    angle += 180.0;
                } else if (x > 100 && y > 100) {
                    angle = Math.atan((double)(y -= 100) / (double)(x -= 100));
                    angle = Math.toDegrees(angle);
                    angle += 90.0;
                }
                return (int)angle / 6;
            }

            public void update(Graphics g) {
                g.clipRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.paint(g);
            }

            public void paintComponent(Graphics comp) {
                super.paintComponent(comp);
                Graphics2D comp2D = (Graphics2D)comp;
                comp2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                comp2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                comp2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                comp2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                if (!this.isShowing()) {
                    return;
                }
                comp2D.clearRect(0, 0, 200, 200);
                comp2D.setStroke(new BasicStroke(1.0f, 1, 1));
                comp2D.setColor(Color.DARK_GRAY);
                comp2D.fillRoundRect(15, 15, 170, 170, 170, 170);
                comp2D.setPaint(new GradientPaint((float)this.offset + 50.0f, (float)this.offset + 20.0f, Color.WHITE, (float)this.offset + 200.0f, (float)this.offset + 200.0f, Color.DARK_GRAY));
                comp2D.fillRoundRect(25, 25, 150, 150, 150, 150);
                comp2D.setColor(Color.BLACK);
                comp2D.drawRoundRect(98, 98, 4, 4, 4, 4);
                comp2D.setColor(Color.BLACK);
                comp2D.setStroke(new BasicStroke(3.5f, 0, 1));
                comp2D.drawLine(100, 10, 100, 30);
                comp2D.drawLine(100, 170, 100, 190);
                comp2D.drawLine(10, 100, 30, 100);
                comp2D.drawLine(170, 100, 190, 100);
                comp2D.setColor(Color.WHITE);
                comp2D.setStroke(new BasicStroke(2.5f, 1, 1));
                comp2D.setFont(this.f);
                comp2D.drawString("XII", 90, 46);
                comp2D.drawString("VI", 93, 164);
                comp2D.drawString("III", 156, 106);
                comp2D.drawString("IX", 34, 106);
                comp2D.setColor(Color.BLACK);
                comp2D.setStroke(new BasicStroke(2.5f, 1, 1));
                comp2D.setFont(this.ff);
                comp2D.drawString(HCPClockComboBox.this.dateFormatSmall.format(calendar.getTime()), 15, 15);
                comp2D.drawLine(100, 100, (int)(Math.sin(Math.toRadians((60 - this.min + 30) * 6)) * 95.0) + 100, (int)(Math.cos(Math.toRadians((60 - this.min + 30) * 6)) * 95.0) + 100);
                comp2D.setColor(Color.RED);
                comp2D.setStroke(new BasicStroke(3.5f, 1, 1));
                comp2D.drawLine(100, 100, (int)(Math.sin(Math.toRadians((12 - this.hour + 6) * 30)) * 65.0) + 100, (int)(Math.cos(Math.toRadians((12 - this.hour + 6) * 30)) * 65.0) + 100);
                comp2D.setColor(Color.WHITE);
                comp2D.setStroke(new BasicStroke(1.0f, 1, 1));
                comp2D.drawLine(100, 100, (int)(Math.sin(Math.toRadians((60 - this.sec + 30) * 6)) * 75.0) + 100, (int)(Math.cos(Math.toRadians((60 - this.sec + 30) * 6)) * 75.0) + 100);
            }
        }
    }

    private class LipstikDateComboBoxUI
    extends LipstikComboBoxUI {
        private LipstikDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    private class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        private MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    private class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        private MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    private class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        private WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }
}

