/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AboutDialog;
import gui.HCPArrowPopButton;
import gui.HCPColors;
import gui.ImageTiledPanel;
import gui.rightPanels.ArtikliPanel;
import gui.rightPanels.FiskalizacijaPanel;
import gui.rightPanels.GPRSPanel;
import gui.rightPanels.HCPPanel;
import gui.rightPanels.HCPServerPanel;
import gui.rightPanels.JMerePanel;
import gui.rightPanels.JournalPanel;
import gui.rightPanels.KasiriPanel;
import gui.rightPanels.OdeljenjaPanel;
import gui.rightPanels.PoreskeStopePanel;
import gui.rightPanels.ReklamaPanel;
import gui.rightPanels.RightPanel;
import gui.rightPanels.RightPanelListener;
import gui.rightPanels.SettingsPanel;
import gui.rightPanels.ToolsPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import objects.Settings;
import objects.lang.LanguageStrings;
import util.SysUtil;
import util.XML.XmlExecuter;

public final class GlavniFrame
extends JFrame
implements WindowListener {
    public static final String version = "ver. 2.02";
    public static final boolean HCP = false;
    public static final boolean SERTIFICATE = false;
    public static final boolean TEST_PRODAJE = false;
    public static boolean BEST_LC;
    public static boolean PRINTER;
    public static boolean BEST;
    public static boolean INTEGRA;
    public JPanel rightPane;
    public JPanel leftPanel;
    public JPanel mainPanel;
    public CardLayout cLayout;
    private JScrollPane scr;
    public SettingsPanel setPane;
    public HCPServerPanel hcpServerPanel;
    public ArtikliPanel articlePanel;
    public GPRSPanel GPRSPane;
    public ToolsPanel toolsPanel;
    private final JButton hideAll;
    public static final Image tile;
    public static Font font;
    private static final String mainTitle = "HCP d.o.o.";
    private static GlavniFrame instance;

    static {
        tile = new ImageIcon("images/tile.jpg").getImage();
        font = new Font("SansSerif", 0, 10);
    }

    public static GlavniFrame getInstance() {
        if (instance == null) {
            instance = new GlavniFrame();
        }
        return instance;
    }

    private GlavniFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBackground(HCPColors.getColorM2st());
        this.leftPanel = new ImageTiledPanel(tile);
        this.leftPanel.setLayout(new GridLayout(18, 1, 0, 2));
        this.leftPanel.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.leftPanel.setBackground(HCPColors.getColorM2st());
        this.leftPanel.setPreferredSize(new Dimension(150, 504));
        this.leftPanel.setMinimumSize(new Dimension(150, 504));
        this.leftPanel.setIgnoreRepaint(true);
        this.hideAll = new JButton("<<");
        this.hideAll.setHorizontalAlignment(2);
        this.hideAll.setBackground(HCPColors.getColorM2st());
        this.hideAll.setForeground(HCPColors.getColorM3st());
        this.hideAll.setBorder(new MatteBorder(1, 1, 1, 1, HCPColors.getColorM2st()));
        this.hideAll.setFont(font);
        this.hideAll.setOpaque(false);
        this.setFont(font);
        this.hideAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean visible = GlavniFrame.this.setPane.button.isVisible();
                int i = 0;
                while (i < RightPanelListener.vec.size()) {
                    HCPArrowPopButton pom = ((RightPanel)RightPanelListener.vec.elementAt((int)i)).button;
                    pom.setVisible(!visible);
                    ++i;
                }
                if (!visible) {
                    GlavniFrame.this.leftPanel.setPreferredSize(new Dimension(150, 500));
                    GlavniFrame.this.hideAll.setText("<<");
                } else {
                    GlavniFrame.this.leftPanel.setPreferredSize(new Dimension(30, 500));
                    GlavniFrame.this.hideAll.setText(">>");
                }
            }
        });
        this.leftPanel.add(this.hideAll);
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.cLayout = new CardLayout();
        this.rightPane = new JPanel(this.cLayout);
        this.scr = new JScrollPane(this.rightPane, 20, 30);
        this.mainPanel.add((Component)this.scr, "Center");
        this.setContentPane(this.mainPanel);
        InputMap mapIn = this.scr.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(112, 0), "1");
        mapIn.put(KeyStroke.getKeyStroke(113, 0), "2");
        ActionMap actMap = this.scr.getActionMap();
        actMap.put("1", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.getInstance().setVisible(true);
            }
        });
    }

    public final void init() {
        try {
            PRINTER = Settings.getInstance().getCash().equalsIgnoreCase("PRINTER");
            BEST_LC = Settings.getInstance().getCash().equalsIgnoreCase("BEST_LC");
            BEST = Settings.getInstance().getCash().equalsIgnoreCase("BEST");
            INTEGRA = Settings.getInstance().getCash().equalsIgnoreCase("INTEGRA");
            this.articlePanel = new ArtikliPanel();
            new KasiriPanel();
            new ReklamaPanel();
            new PoreskeStopePanel();
            new JMerePanel();
            if (!PRINTER) {
                new OdeljenjaPanel();
            }
            if (!PRINTER) {
                new JournalPanel();
            }
            if (!PRINTER) {
                this.hcpServerPanel = new HCPServerPanel();
            }
            this.toolsPanel = new ToolsPanel();
            this.setPane = new SettingsPanel();
            this.GPRSPane = new GPRSPanel();
            new FiskalizacijaPanel();
            new HCPPanel();
            new RightPanel(LanguageStrings.getInstance().getStringByName("PROGRAM_END"), 'X', LanguageStrings.getInstance().getStringByName("PROGRAM_END_TOOLTIP"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.setResizable(true);
        ImageIcon slika = new ImageIcon("images/hcp.png");
        this.setIconImage(slika.getImage());
        this.setTitle(mainTitle);
        int x = Settings.getInstance().getPosx();
        int y = Settings.getInstance().getPosy();
        this.setLocation(x, y);
        x = Settings.getInstance().getSizex();
        y = Settings.getInstance().getSizey();
        this.setPreferredSize(new Dimension(x, y));
        this.toolsPanel.button.doClick();
        this.pack();
        this.setVisible(true);
        this.setExtendedState(this.getExtendedState() | Settings.getInstance().getState());
    }

    public void appExit() {
        if (JOptionPane.showConfirmDialog(this, LanguageStrings.getAreYouSure(), "PROGRAM EXIT", 2) != 0) {
            return;
        }
        Settings settings = Settings.getInstance();
        if ((instance.getExtendedState() & 6) <= 0) {
            settings.setPosx(this.getX());
            settings.setPosy(this.getY());
            settings.setSizex(this.getWidth());
            settings.setSizey(this.getHeight());
        }
        settings.setState(this.getExtendedState());
        File file = new File("properties", "settings.xml");
        file.mkdirs();
        if (file.exists()) {
            file.delete();
        }
        try {
            XmlExecuter.getInstance().write(settings, file.getPath());
            SysUtil.delay(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public void windowClosing(WindowEvent e) {
        this.appExit();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

