/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPRadioButton;
import gui.HCPTextField;
import gui.TimeChooserDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CommandFileDialog
extends JDialog
implements ActionListener {
    private JPanel mainPane;
    private HCPRadioButton rbFiscal;
    private HCPRadioButton rbJournal;
    private HCPRadioButton rbArticles;
    private HCPRadioButton rbComand;
    private HCPRadioButton rbSend;
    private HCPRadioButton rbFiscalFISC;
    private HCPRadioButton rbFiscalLAST;
    private ButtonGroup bgFiscal;
    private HCPRadioButton rbJournalJORN;
    private HCPRadioButton rbJournalBASE;
    private ButtonGroup bgJournal;
    private HCPRadioButton rbArticlesARTS;
    private HCPRadioButton rbArticlesARTD;
    private ButtonGroup bgArticles;
    private HCPTextField tfPath;
    private HCPGreyButton buttonTime;
    private HCPGreyButton buttonSaveFile;
    private SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy HHmm");
    private String date;
    private static CommandFileDialog instance = null;

    public static CommandFileDialog getInstance() {
        if (instance == null) {
            instance = new CommandFileDialog();
        }
        return instance;
    }

    private CommandFileDialog() {
        super((Frame)GlavniFrame.getInstance(), "Command file dialog");
        ImageIcon slikaFloppy = new ImageIcon("images/Floppy_Drive_Small.png");
        ImageIcon slikaClock = new ImageIcon("images/clock.png");
        this.mainPane = new JPanel(new BorderLayout(10, 10));
        this.mainPane.getComponents();
        TitledBorder title = BorderFactory.createTitledBorder("choose options");
        title.setTitleFont(GlavniFrame.font);
        this.mainPane.setBorder(title);
        JPanel leftPanel = new JPanel(new GridLayout(5, 1, 5, 5));
        this.rbFiscal = new HCPRadioButton("FISCAL", true);
        leftPanel.add(this.rbFiscal);
        this.rbJournal = new HCPRadioButton("JOURNAL", true);
        leftPanel.add(this.rbJournal);
        this.rbArticles = new HCPRadioButton("ARTICLES", false);
        leftPanel.add(this.rbArticles);
        this.rbComand = new HCPRadioButton("COMMAND", false);
        leftPanel.add(this.rbComand);
        this.rbSend = new HCPRadioButton("SEND", false);
        leftPanel.add(this.rbSend);
        JPanel centerPanel = new JPanel(new GridLayout(5, 1, 5, 5));
        JPanel fiscPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        fiscPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rbFiscalFISC = new HCPRadioButton("FISC", true);
        fiscPanel.add(this.rbFiscalFISC);
        this.rbFiscalLAST = new HCPRadioButton("LAST");
        fiscPanel.add(this.rbFiscalLAST);
        this.bgFiscal = new ButtonGroup();
        this.bgFiscal.add(this.rbFiscalFISC);
        this.bgFiscal.add(this.rbFiscalLAST);
        JPanel journalPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        journalPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rbJournalJORN = new HCPRadioButton("JORN", true);
        journalPanel.add(this.rbJournalJORN);
        this.rbJournalBASE = new HCPRadioButton("BASE");
        journalPanel.add(this.rbJournalBASE);
        this.bgJournal = new ButtonGroup();
        this.bgJournal.add(this.rbJournalBASE);
        this.bgJournal.add(this.rbJournalJORN);
        JPanel artsPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        artsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rbArticlesARTD = new HCPRadioButton("ARTD");
        artsPanel.add(this.rbArticlesARTD);
        this.rbArticlesARTS = new HCPRadioButton("ARTS", true);
        artsPanel.add(this.rbArticlesARTS);
        this.bgArticles = new ButtonGroup();
        this.bgArticles.add(this.rbArticlesARTS);
        this.bgArticles.add(this.rbArticlesARTD);
        this.rbArticlesARTD.setEnabled(false);
        this.rbArticlesARTS.setEnabled(false);
        JPanel commandPanel = new JPanel(new GridLayout(1, 1, 5, 5));
        commandPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tfPath = new HCPTextField();
        commandPanel.add(this.tfPath);
        this.tfPath.setEditable(false);
        JPanel sendPanel = new JPanel(new GridLayout(1, 1, 5, 5));
        sendPanel.setBorder(new EmptyBorder(0, 85, 0, 5));
        this.buttonTime = new HCPGreyButton("TIME", slikaClock);
        sendPanel.add(this.buttonTime);
        this.buttonTime.setEnabled(false);
        JPanel southPanel = new JPanel(new GridLayout(1, 1, 5, 5));
        southPanel.setBorder(new EmptyBorder(5, 65, 5, 65));
        this.buttonSaveFile = new HCPGreyButton("SAVE FILE", slikaFloppy);
        southPanel.add(this.buttonSaveFile);
        this.buttonTime.addActionListener(this);
        this.buttonSaveFile.addActionListener(this);
        centerPanel.add(fiscPanel);
        centerPanel.add(journalPanel);
        centerPanel.add(artsPanel);
        centerPanel.add(commandPanel);
        centerPanel.add(sendPanel);
        this.mainPane.add((Component)leftPanel, "West");
        this.mainPane.add((Component)centerPanel, "Center");
        this.mainPane.add((Component)southPanel, "South");
        this.rbFiscal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommandFileDialog.this.rbFiscal.isSelected()) {
                    CommandFileDialog.this.rbFiscalFISC.setEnabled(true);
                    CommandFileDialog.this.rbFiscalLAST.setEnabled(true);
                } else {
                    CommandFileDialog.this.rbFiscalFISC.setEnabled(false);
                    CommandFileDialog.this.rbFiscalLAST.setEnabled(false);
                }
            }
        });
        this.rbJournal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommandFileDialog.this.rbJournal.isSelected()) {
                    CommandFileDialog.this.rbJournalBASE.setEnabled(true);
                    CommandFileDialog.this.rbJournalJORN.setEnabled(true);
                } else {
                    CommandFileDialog.this.rbJournalBASE.setEnabled(false);
                    CommandFileDialog.this.rbJournalJORN.setEnabled(false);
                }
            }
        });
        this.rbArticles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommandFileDialog.this.rbArticles.isSelected()) {
                    CommandFileDialog.this.rbArticlesARTD.setEnabled(true);
                    CommandFileDialog.this.rbArticlesARTS.setEnabled(true);
                } else {
                    CommandFileDialog.this.rbArticlesARTD.setEnabled(false);
                    CommandFileDialog.this.rbArticlesARTS.setEnabled(false);
                }
            }
        });
        this.rbComand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommandFileDialog.this.rbComand.isSelected()) {
                    CommandFileDialog.this.tfPath.setEditable(true);
                } else {
                    CommandFileDialog.this.tfPath.setEditable(false);
                }
            }
        });
        this.rbSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CommandFileDialog.this.rbSend.isSelected()) {
                    CommandFileDialog.this.buttonTime.setEnabled(true);
                } else {
                    CommandFileDialog.this.buttonTime.setEnabled(false);
                }
            }
        });
        this.mainPane.setPreferredSize(new Dimension(320, 240));
        this.setContentPane(this.mainPane);
        this.setResizable(false);
        this.pack();
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(GlavniFrame.getInstance());
    }

    public void actionPerformed(ActionEvent cmd) {
        if (cmd.getSource() == this.buttonTime) {
            this.setTime();
        }
        if (cmd.getSource() == this.buttonSaveFile) {
            new Thread(){

                public void run() {
                    try {
                        CommandFileDialog.this.saveFile();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(CommandFileDialog.this.mainPane, e.getMessage(), " ERROR", 0);
                    }
                }
            }.start();
        }
    }

    public void setTime() {
        this.setVisible(false);
        this.setAlwaysOnTop(false);
        TimeChooserDialog tcd = new TimeChooserDialog();
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.date = this.sdf.format(new Date(tcd.getTime()));
    }

    public void saveFile() throws Exception {
        String IBFK = JOptionPane.showInputDialog(this.mainPane, (Object)"Enter IBFK");
        if (IBFK == null) {
            return;
        }
        if (IBFK.length() != 7) {
            throw new Exception("IBFK error. Enter 7 letters! e.g. TA12345");
        }
        File file = new File("COMMAND_FILES");
        file.mkdirs();
        file = new File("COMMAND_FILES", String.valueOf(IBFK) + "command.hcp");
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            BufferedOutputStream buff = new BufferedOutputStream(out);
            if (this.rbFiscal.isSelected()) {
                if (this.rbFiscalFISC.isSelected()) {
                    buff.write("FISC\r\n".getBytes());
                } else {
                    buff.write("LAST\r\n".getBytes());
                }
            }
            if (this.rbJournal.isSelected()) {
                if (this.rbJournalBASE.isSelected()) {
                    buff.write("BASE\r\n".getBytes());
                } else {
                    buff.write("JORN\r\n".getBytes());
                }
            }
            if (this.rbArticles.isSelected()) {
                if (this.rbArticlesARTD.isSelected()) {
                    buff.write("ARTD\r\n".getBytes());
                } else {
                    buff.write("ARTS\r\n".getBytes());
                }
            }
            if (this.rbComand.isSelected()) {
                buff.write(("COMD " + this.tfPath.getText().trim() + "\r\n").getBytes());
            }
            if (this.rbSend.isSelected()) {
                buff.write(("SEND " + this.date + "\r\n").getBytes());
            } else {
                buff.write("SEND\r\n".getBytes());
            }
            buff.flush();
        }
        catch (Exception e) {
            out.close();
        }
        JOptionPane.showMessageDialog(this.mainPane, "File is in COMMAND_FILES folder!", " OK", 1);
    }
}

