/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.ImageTiledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import objects.Settings;
import objects.lang.LanguageStrings;

public class AboutDialog
extends JDialog
implements ActionListener {
    private JLabel slika;
    private HCPGreyButton mail;
    private HCPGreyButton web;
    private HCPGreyButton reset;
    private JPanel pane;
    private JPanel buttonPanel;
    private static AboutDialog instance = null;

    public static AboutDialog getInstance() {
        if (instance == null) {
            instance = new AboutDialog();
        }
        return instance;
    }

    private AboutDialog() {
        super(GlavniFrame.getInstance());
        this.setTitle("About...");
        this.slika = new JLabel();
        ImageIcon ico = new ImageIcon("images\\hcp-banner.png");
        this.slika.setIcon(ico);
        this.slika.setBorder(new SoftBevelBorder(0));
        this.mail = new HCPGreyButton("Mail");
        this.mail.setActionCommand("mail");
        this.mail.setToolTipText("mailto:support@hcp.rs");
        this.mail.setIcon(new ImageIcon("images\\E-Mail.png"));
        this.mail.addActionListener(this);
        this.web = new HCPGreyButton("Web");
        this.web.setActionCommand("web");
        this.web.setToolTipText("http:/www.hcp.rs/");
        this.web.setIcon(new ImageIcon("images\\IE.png"));
        this.web.addActionListener(this);
        this.reset = new HCPGreyButton(LanguageStrings.getInstance().getStringByName("RESET_PROGRAM"));
        this.reset.setActionCommand("reset");
        this.reset.setToolTipText(LanguageStrings.getInstance().getStringByName("RESET_PROGRAM_TOOLTIP"));
        this.reset.setIcon(new ImageIcon("images\\reset.png"));
        this.reset.addActionListener(this);
        this.pane = new ImageTiledPanel(new ImageIcon("images/tile.jpg").getImage());
        this.pane.setLayout(new BorderLayout());
        this.pane.add((Component)this.slika, "Center");
        this.buttonPanel = new JPanel(new GridLayout(5, 1, 5, 5));
        this.buttonPanel.setPreferredSize(new Dimension(170, 160));
        this.buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.buttonPanel.add(new HCPLabel("ver. 2.02", 4));
        this.buttonPanel.add(this.mail);
        this.buttonPanel.add(this.web);
        this.buttonPanel.add(new JLabel(""));
        this.buttonPanel.add(this.reset);
        this.pane.add((Component)this.buttonPanel, "East");
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        InputMap mapIn = this.buttonPanel.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(27, 0), "2");
        ActionMap actMap = this.buttonPanel.getActionMap();
        actMap.put("2", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.getInstance().setVisible(false);
            }
        });
        this.buttonPanel.setOpaque(false);
        this.pane.setPreferredSize(new Dimension(385, 165));
        this.pane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.pane);
        this.pack();
        this.setLocationRelativeTo(GlavniFrame.getInstance());
    }

    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equalsIgnoreCase("web")) {
            try {
                Runtime.getRuntime().exec("cmd.exe /c start  http://www.hcp.rs");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (str.equalsIgnoreCase("mail")) {
            try {
                Runtime.getRuntime().exec("cmd.exe /c start  mailTo:support@hcp.rs");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (str.equalsIgnoreCase("reset")) {
            Settings.getInstance().reset();
            this.setVisible(false);
            if (JOptionPane.showConfirmDialog(this, LanguageStrings.getRestart(), "PROGRAM RESTART", 2, 2) == 0) {
                try {
                    Runtime.getRuntime().exec("HCP Fiscal.exe");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
            }
        }
    }
}

