/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import ftp.FtpWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;

public class HcpFtpClient {
    public static String commandsRemotePath = "";
    public static String reportsRemotePath = "";
    public static String definitionRemotePath = "";
    public static String ftpAddress = "";
    public static int ftpPort = 21;
    public static String ftpUsername = "";
    public static String ftpPassword = "";
    private static FtpWrapper client = null;
    public static int BUFFER_SIZE = 1024;

    public static void init() throws Exception {
        if (client == null) {
            client = new FtpWrapper();
            client.openServer(ftpAddress, ftpPort);
            client.login(ftpUsername, ftpPassword);
        }
    }

    private static void test() throws Exception {
        try {
            client.noop();
            return;
        }
        catch (Exception e) {
            try {
                client.reInit();
            }
            catch (Exception e2) {
                try {
                    client.closeServer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                client = null;
                HcpFtpClient.init();
            }
            return;
        }
    }

    public static int getFile(File localFile, String remoteFile) throws Exception {
        byte[] buffer = new byte[BUFFER_SIZE];
        if (localFile.exists()) {
            localFile.delete();
        }
        client.binary();
        File tmpFile = new File(localFile.getParentFile(), String.valueOf(localFile.getName()) + ".tmp");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        FileOutputStream out = new FileOutputStream(tmpFile);
        TelnetInputStream in = client.get(remoteFile);
        int counter = 0;
        int bytes = 0;
        while ((bytes = ((InputStream)in).read(buffer)) >= 0) {
            out.write(buffer, 0, bytes);
            out.flush();
            counter += bytes;
        }
        out.close();
        ((InputStream)in).close();
        tmpFile.renameTo(localFile);
        return counter;
    }

    public static int putFile(File localFile, String remoteFile) throws Exception {
        byte[] buffer = new byte[BUFFER_SIZE];
        client.binary();
        FileInputStream in = new FileInputStream(localFile);
        TelnetOutputStream out = client.put(remoteFile);
        int counter = 0;
        int bytes = 0;
        while ((bytes = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, bytes);
            ((OutputStream)out).flush();
            counter += bytes;
        }
        ((OutputStream)out).close();
        in.close();
        return counter;
    }

    public static void uploadToFile(byte[] buffer, int offset, int len, String remoteFile) throws Exception {
        HcpFtpClient.test();
        client.binary();
        TelnetOutputStream out = client.put(remoteFile);
        ((OutputStream)out).write(buffer, offset, len);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    public static int getFileSize(String fileName) throws Exception {
        TelnetInputStream lst = client.list();
        String str = "";
        fileName = fileName.toLowerCase();
        while (true) {
            int c = ((InputStream)lst).read();
            char ch = (char)c;
            if (c < 0 || ch == '\n') {
                if ((str = str.toLowerCase()).indexOf(fileName) >= 0) {
                    StringTokenizer tk = new StringTokenizer(str);
                    int index = 0;
                    while (tk.hasMoreTokens()) {
                        String token = tk.nextToken();
                        if (index == 4) {
                            try {
                                return Integer.parseInt(token);
                            }
                            catch (NumberFormatException ex) {
                                return -1;
                            }
                        }
                        ++index;
                    }
                }
                str = "";
            }
            if (c <= 0) break;
            if (ch == '\n') continue;
            str = String.valueOf(str) + ch;
        }
        return -1;
    }

    public static boolean isDirectory(String fileName) throws Exception {
        TelnetInputStream lst = client.list();
        String str = "";
        fileName = fileName.toLowerCase();
        while (true) {
            int c = ((InputStream)lst).read();
            char ch = (char)c;
            if (c < 0 || ch == '\n') {
                if ((str = str.toLowerCase()).indexOf(fileName) >= 0) {
                    return str.trim().charAt(0) == 'd';
                }
                str = "";
            }
            if (c <= 0) break;
            if (ch == '\n') continue;
            str = String.valueOf(str) + ch;
        }
        throw new Exception("No sutch file!");
    }

    public static Vector listCurrentFolder() throws Exception {
        Vector<String> vec = new Vector<String>();
        TelnetInputStream lst = client.list();
        String str = "";
        while (true) {
            int c = ((InputStream)lst).read();
            char ch = (char)c;
            if (c < 0 || ch == '\n') {
                StringTokenizer tk = new StringTokenizer(str);
                int index = 0;
                while (tk.hasMoreTokens()) {
                    String token = tk.nextToken();
                    if (index == 8) {
                        vec.add(token);
                    }
                    ++index;
                }
                str = "";
            }
            if (c <= 0) break;
            if (ch == '\n') continue;
            str = String.valueOf(str) + ch;
        }
        return vec;
    }

    public static void testAllSettings() throws Exception {
        HcpFtpClient.test();
        client.cd(reportsRemotePath);
        client.cd(definitionRemotePath);
        client.cd(commandsRemotePath);
    }

    public static void cdReports() throws Exception {
        HcpFtpClient.test();
        client.cd(reportsRemotePath);
    }

    public static void cdDefinitions() throws Exception {
        HcpFtpClient.test();
        client.cd(definitionRemotePath);
    }

    public static void cdCommands() throws Exception {
        HcpFtpClient.test();
        client.cd(commandsRemotePath);
    }

    public static void cdRoot() throws Exception {
        HcpFtpClient.test();
        client.cd("/");
    }
}

