/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import java.io.IOException;
import sun.net.ftp.FtpClient;

public class FtpWrapper
extends FtpClient {
    public String pwd() throws IOException {
        this.issueCommand("PWD");
        if (this.isValidResponse()) {
            String response = this.getResponseString().substring(4).trim();
            if (response.startsWith("\"")) {
                response = response.substring(1);
            }
            if (response.endsWith("\"")) {
                response = response.substring(0, response.length() - 1);
            }
            return response;
        }
        return "";
    }

    public boolean cdup() throws IOException {
        this.issueCommand("CDUP");
        return this.isValidResponse();
    }

    public boolean mkdir(String newDir) throws IOException {
        this.issueCommand("MKDIR " + newDir);
        return this.isValidResponse();
    }

    public boolean deleteFile(String fileName) throws IOException {
        this.issueCommand("DELE " + fileName);
        return this.isValidResponse();
    }

    private int getResponseCode() throws NumberFormatException {
        return Integer.parseInt(this.getResponseString().substring(0, 3));
    }

    private boolean isValidResponse() {
        try {
            int respCode = this.getResponseCode();
            return respCode >= 200 && respCode < 300;
        }
        catch (Exception e) {
            return false;
        }
    }
}

