/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import ftp.HcpFtpClient;
import gui.GlavniFrame;
import gui.HCPGreyButton;
import gui.HCPLabel;
import gui.HCPNumTextField;
import gui.HCPTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class FtpConfigDialog
extends JDialog
implements ActionListener {
    public HCPTextField commandsRemotePath;
    public HCPTextField ipAddress;
    public HCPNumTextField port;
    public HCPTextField username;
    public HCPTextField password;
    private JPanel mainPane;
    private HCPGreyButton okButton;
    private HCPGreyButton cancelButton;
    public boolean configured = false;

    public FtpConfigDialog() {
        this.setTitle("FTP SERVER");
        this.mainPane = new JPanel(new BorderLayout());
        this.mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        buttonPanel.setPreferredSize(new Dimension(300, 30));
        buttonPanel.setBorder(new EmptyBorder(5, 35, 5, 35));
        this.okButton = new HCPGreyButton("Ok");
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new HCPGreyButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        JPanel ftpAddressPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        ftpAddressPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("FTP adresa"), new EmptyBorder(5, 5, 5, 5)));
        ftpAddressPanel.add(new HCPLabel("address: "));
        this.ipAddress = new HCPTextField(HcpFtpClient.ftpAddress);
        ftpAddressPanel.add(this.ipAddress);
        ftpAddressPanel.add(new HCPLabel("port: "));
        this.port = new HCPNumTextField("" + HcpFtpClient.ftpPort);
        ftpAddressPanel.add(this.port);
        centerPanel.add(ftpAddressPanel);
        JPanel ftpUserPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        ftpUserPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("FTP korisnik"), new EmptyBorder(5, 5, 5, 5)));
        ftpUserPanel.add(new HCPLabel("username: "));
        this.username = new HCPTextField(HcpFtpClient.ftpUsername);
        ftpUserPanel.add(this.username);
        ftpUserPanel.add(new HCPLabel("password: "));
        this.password = new HCPTextField(HcpFtpClient.ftpPassword);
        ftpUserPanel.add(this.password);
        centerPanel.add(ftpUserPanel);
        JPanel ftpPathsPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        ftpPathsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("FTP putanja"), new EmptyBorder(5, 5, 5, 5)));
        ftpPathsPanel.add(new HCPLabel("command path: "));
        this.commandsRemotePath = new HCPTextField(HcpFtpClient.commandsRemotePath);
        ftpPathsPanel.add(this.commandsRemotePath);
        centerPanel.add(ftpPathsPanel);
        InputMap mapIn = this.mainPane.getInputMap(2);
        mapIn.put(KeyStroke.getKeyStroke(27, 0), "2");
        ActionMap actMap = this.mainPane.getActionMap();
        actMap.put("2", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FtpConfigDialog.this.setVisible(false);
            }
        });
        this.mainPane.add((Component)centerPanel, "Center");
        this.mainPane.add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.setContentPane(this.mainPane);
        this.pack();
        this.setLocationRelativeTo(GlavniFrame.getInstance());
        this.setModal(true);
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int p;
            try {
                if (this.ipAddress.getText().length() <= 0) {
                    throw new Exception("FTP server error!");
                }
                p = Integer.parseInt(this.port.getText());
                if (this.username.getText().length() <= 0) {
                    throw new Exception("FTP server username error!");
                }
                if (this.password.getText().length() <= 0) {
                    throw new Exception("FTP server password error!");
                }
                if (this.commandsRemotePath.getText().length() <= 0) {
                    throw new Exception("FTP server command path error!");
                }
                if (!this.commandsRemotePath.getText().startsWith("/")) {
                    throw new Exception("FTP server command path error! Start from root folder (/path)");
                }
                if (!this.commandsRemotePath.getText().endsWith("/")) {
                    throw new Exception("FTP server command path error! End path with /");
                }
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this, "Wrong port!", "ERROR", 0);
                return;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage(), "ERROR", 0);
                return;
            }
            HcpFtpClient.ftpAddress = this.ipAddress.getText();
            HcpFtpClient.ftpPort = p;
            HcpFtpClient.ftpUsername = this.username.getText();
            HcpFtpClient.ftpPassword = this.password.getText();
            HcpFtpClient.commandsRemotePath = this.commandsRemotePath.getText();
            this.configured = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.configured = false;
            this.setVisible(false);
        }
    }
}

