/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.jdbc2.optional.MysqlXAConnection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class JDBC4MysqlXAConnection
extends MysqlXAConnection {
    private Map<StatementEventListener, StatementEventListener> statementEventListeners = new HashMap<StatementEventListener, StatementEventListener>();

    public JDBC4MysqlXAConnection(ConnectionImpl connection, boolean logXaCommands) throws SQLException {
        super(connection, logXaCommands);
    }

    @Override
    public synchronized void close() throws SQLException {
        super.close();
        if (this.statementEventListeners != null) {
            this.statementEventListeners.clear();
            this.statementEventListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatementEventListener(StatementEventListener listener) {
        Map<StatementEventListener, StatementEventListener> map = this.statementEventListeners;
        synchronized (map) {
            this.statementEventListeners.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatementEventListener(StatementEventListener listener) {
        Map<StatementEventListener, StatementEventListener> map = this.statementEventListeners;
        synchronized (map) {
            this.statementEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStatementEvent(StatementEvent event) throws SQLException {
        Map<StatementEventListener, StatementEventListener> map = this.statementEventListeners;
        synchronized (map) {
            for (StatementEventListener listener : this.statementEventListeners.keySet()) {
                listener.statementClosed(event);
            }
        }
    }
}

