/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.util.LipstikBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class LipstikFileChooserUI
extends BasicFileChooserUI
implements MouseListener {
    private static final Hashtable iconCache = new Hashtable();
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private JPanel centerPanel;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JButton approveButton;
    private JButton cancelButton;
    private JComboBox directoryComboBox;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JList list;
    private JLabel lookInLabel;
    private JTable detailsTable;
    private JPopupMenu contextMenu;
    private JTextField fileNameTextField;
    private ListSelectionModel listSelectionModel;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private FilterComboBoxModel filterComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private boolean useShellFolder;
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static final int PREF_WIDTH = 483;
    private static final int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(483, 326);
    private static final int MIN_WIDTH = 500;
    private static final int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(500, 326);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private int filesOfTypeLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private Icon upFolderIconDisabled = UIManager.getIcon("FileChooser.upFolderIconDisabled");
    private Icon newFolderIconDisabled = UIManager.getIcon("FileChooser.newFolderIconDisabled");
    static IndentIcon indentIcon = null;

    public static ComponentUI createUI(JComponent c) {
        return new LipstikFileChooserUI((JFileChooser)c);
    }

    public LipstikFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    public void installComponents(JFileChooser fc) {
        File[] cbFolders;
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(8, 8, 0, 7));
        fc.setLayout(new BorderLayout(0, 8));
        JPanel topPanel = new JPanel(new BorderLayout(5, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(new DirectoryComboBoxRenderer());
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setRolloverEnabled(true);
        upFolderButton.setFocusable(false);
        upFolderButton.setBorder(LipstikBorderFactory.getButtonFileChooserBorder());
        upFolderButton.setDisabledIcon(this.upFolderIconDisabled);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        topButtonPanel.add(upFolderButton);
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.homeFolderIcon);
        b.setToolTipText(toolTipText);
        b.setRolloverEnabled(true);
        b.setFocusable(false);
        b.setBorder(LipstikBorderFactory.getButtonFileChooserBorder());
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        b = new JButton(this.getNewFolderAction());
        b.setText(null);
        b.setIcon(this.newFolderIcon);
        b.setDisabledIcon(this.newFolderIconDisabled);
        b.setToolTipText(this.newFolderToolTipText);
        b.setRolloverEnabled(true);
        b.setFocusable(false);
        b.setBorder(LipstikBorderFactory.getButtonFileChooserBorder());
        b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(new Dimension(6, 1)));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        ViewButtonListener viewButtonListener = new ViewButtonListener(fc);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setRolloverEnabled(true);
        this.listViewButton.setFocusable(false);
        this.listViewButton.setBorder(LipstikBorderFactory.getButtonFileChooserBorder());
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        viewButtonGroup.add(this.listViewButton);
        topButtonPanel.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setRolloverEnabled(true);
        this.detailsViewButton.setFocusable(false);
        this.detailsViewButton.setBorder(LipstikBorderFactory.getButtonFileChooserBorder());
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        viewButtonGroup.add(this.detailsViewButton);
        topButtonPanel.add(this.detailsViewButton);
        this.useShellFolder = false;
        File[] roots = fsv.getRoots();
        if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(fc);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.centerPanel, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        JLabel fileNameLabel = new JLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        c.weightx = 0.0;
        this.bottomPanel.add((Component)fileNameLabel, c);
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!LipstikFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    LipstikFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        fileNameLabel.setLabelFor(this.fileNameTextField);
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        c.gridwidth = 0;
        c.weightx = 0.1;
        this.bottomPanel.add((Component)this.fileNameTextField, c);
        JLabel filesOfTypeLabel = new JLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        c.gridwidth = -1;
        c.weightx = 0.0;
        this.bottomPanel.add((Component)filesOfTypeLabel, c);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        JComboBox<Object> filterComboBox = new JComboBox<Object>(this.filterComboBoxModel);
        filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypeLabel.setLabelFor(filterComboBox);
        c.gridwidth = 0;
        c.weightx = 0.1;
        this.bottomPanel.add(filterComboBox, c);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2, 0, 10));
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel.add(this.cancelButton);
        c.gridwidth = 0;
        this.bottomPanel.add((Component)this.buttonPanel, c);
        fc.add((Component)this.bottomPanel, "South");
        this.createContextMenu();
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", l);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", l);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", l);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", l);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", l);
    }

    protected void createContextMenu() {
        this.contextMenu = new JPopupMenu();
        this.contextMenu.add(new JMenuItem(this.listViewButtonToolTipText));
        this.contextMenu.add(new JMenuItem(this.detailsViewButtonToolTipText));
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        final JFileChooser fileChooser = fc;
        this.list = new JList(){

            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                while (backwards ? i >= 0 : i < max) {
                    String filename = fileChooser.getName((File)model.getElementAt(i));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.setFixedCellHeight(17);
        if (fc.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc));
        this.list.addMouseListener(this.createDoubleClickListener(fc, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent e) {
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    protected JPanel createDetailsView(final JFileChooser fc) {
        DetailsTableModel detailsTableModel = new DetailsTableModel(fc);
        JPanel p = new JPanel(new BorderLayout());
        this.detailsTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 10) {
                    fc.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.detailsTable.setComponentOrientation(fc.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setRowHeight(17);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.setIntercellSpacing(new Dimension(1, 1));
        TableColumnModel columnModel = this.detailsTable.getColumnModel();
        TableColumn[] columns = new TableColumn[5];
        for (int i = 0; i < 5; ++i) {
            columns[i] = columnModel.getColumn(i);
            columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            columnModel.removeColumn(columns[2]);
            columnModel.removeColumn(columns[4]);
        }
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(fc);
        this.detailsTable.setDefaultRenderer(File.class, cellRenderer);
        this.detailsTable.setDefaultRenderer(Date.class, cellRenderer);
        this.detailsTable.setDefaultRenderer(Object.class, cellRenderer);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                int index = LipstikFileChooserUI.this.detailsTable.rowAtPoint(e.getPoint());
                if (index >= 0 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    File f = (File)LipstikFileChooserUI.this.list.getModel().getElementAt(index);
                    try {
                        f = f.getCanonicalFile();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (fc.isTraversable(f)) {
                        LipstikFileChooserUI.this.detailsTable.clearSelection();
                        if (File.separatorChar == '\\' && f.getPath().endsWith(".lnk")) {
                            try {
                                ShellFolder linkedTo = ShellFolder.getShellFolder(f).getLinkLocation();
                                if (linkedTo == null || !fc.isTraversable(linkedTo)) {
                                    return;
                                }
                                f = linkedTo;
                            }
                            catch (FileNotFoundException ex) {
                                return;
                            }
                        }
                        fc.setCurrentDirectory(f);
                    } else {
                        LipstikFileChooserUI.this.getFileChooser().approveSelection();
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.detailsTable);
        scrollpane.setComponentOrientation(fc.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                LipstikFileChooserUI.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new BasicFileChooserUI.SelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JFileChooser chooser = LipstikFileChooserUI.this.getFileChooser();
                    FileSystemView fsv = chooser.getFileSystemView();
                    JList list = (JList)e.getSource();
                    if (chooser.isMultiSelectionEnabled()) {
                        File[] files = null;
                        Object[] objects = list.getSelectedValues();
                        int j = 0;
                        int n = objects.length;
                        if (n == 1 && ((File)objects[0]).isDirectory() && chooser.isTraversable((File)objects[0]) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem((File)objects[0]))) {
                            LipstikFileChooserUI.this.setDirectorySelected(true);
                            LipstikFileChooserUI.this.setDirectory((File)objects[0]);
                        } else {
                            files = new File[n];
                            for (int i = 0; i < n; ++i) {
                                File f = (File)objects[i];
                                if ((!chooser.isFileSelectionEnabled() || !f.isFile()) && (!chooser.isDirectorySelectionEnabled() || !fsv.isFileSystem(f) || !f.isDirectory())) continue;
                                files[j++] = f;
                            }
                            if (j == 0) {
                                files = null;
                            } else if (j < n) {
                                File[] tmpFiles = new File[j];
                                System.arraycopy(files, 0, tmpFiles, 0, j);
                                files = tmpFiles;
                            }
                            LipstikFileChooserUI.this.setDirectorySelected(false);
                        }
                        chooser.setSelectedFiles(files);
                    } else {
                        File file = (File)list.getSelectedValue();
                        if (file != null && file.isDirectory() && chooser.isTraversable(file) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem(file))) {
                            LipstikFileChooserUI.this.setDirectorySelected(true);
                            LipstikFileChooserUI.this.setDirectory(file);
                            chooser.setSelectedFile(null);
                        } else {
                            LipstikFileChooserUI.this.setDirectorySelected(false);
                            if (file != null) {
                                chooser.setSelectedFile(file);
                            }
                        }
                    }
                }
            }
        };
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = LipstikFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < LipstikFileChooserUI.PREF_SIZE.height ? LipstikFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, LipstikFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            File[] files = this.getFileChooser().getSelectedFiles();
            Object[] selectedObjects = this.list.getSelectedValues();
            for (int j = 0; j < selectedObjects.length; ++j) {
                int i;
                for (i = 0; i < files.length && !files[i].equals(selectedObjects[j]); ++i) {
                }
                if (i != files.length || (i = this.getModel().indexOf(selectedObjects[j])) < 0) continue;
                this.listSelectionModel.removeSelectionInterval(i, i);
            }
            for (int i = 0; i < files.length; ++i) {
                int j;
                for (j = 0; j < selectedObjects.length && !files[i].equals(selectedObjects[j]); ++j) {
                }
                if (j != selectedObjects.length || (j = this.getModel().indexOf(files[i])) < 0) continue;
                this.listSelectionModel.addSelectionInterval(j, j);
            }
        } else {
            int i;
            JFileChooser chooser = this.getFileChooser();
            File f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                this.listSelectionModel.setSelectionInterval(i, i);
                this.ensureIndexIsVisible(i);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    public static Icon getIcon(File f, Icon fileIcon, FileSystemView fsv) {
        Icon icon = (Icon)iconCache.get(f);
        if (icon != null) {
            return icon;
        }
        icon = fileIcon;
        if (f != null) {
            icon = f.isDirectory() && !fsv.isDrive(f) && !fsv.isFileSystemRoot(f) && !fsv.isComputerNode(f) && !fsv.isFloppyDrive(f) && !fsv.isRoot(f) ? UIManager.getIcon("FileChooser.folderIcon") : fsv.getSystemIcon(f);
        }
        iconCache.put(f, icon);
        return icon;
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        if (files == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (n > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (n <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
        this.setFileSelected();
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        }
        this.setFileSelected();
    }

    private void doDirectoryChanged() {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(fsv.isFileSystem(currentDirectory) && currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fsv.isFileSystem(currentDirectory)) {
                this.setFileName(currentDirectory.getPath());
            }
        }
    }

    private void doFilterChanged() {
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged() {
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged() {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged() {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged() {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    LipstikFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    LipstikFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    LipstikFileChooserUI.this.doDirectoryChanged();
                } else if (s.equals("fileFilterChanged")) {
                    LipstikFileChooserUI.this.doFilterChanged();
                } else if (s.equals("fileSelectionChanged")) {
                    LipstikFileChooserUI.this.doFileSelectionModeChanged();
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    LipstikFileChooserUI.this.doMultiSelectionChanged();
                } else if (s.equals("AccessoryChangedProperty")) {
                    LipstikFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    LipstikFileChooserUI.this.doApproveButtonTextChanged();
                } else if (s.equals("DialogTypeChangedProperty")) {
                    LipstikFileChooserUI.this.doDialogTypeChanged();
                } else if (!s.equals("ApproveButtonMnemonicChangedProperty")) {
                    if (s.equals("ControlButtonsAreShownChangedProperty")) {
                        LipstikFileChooserUI.this.buttonPanel.setVisible(LipstikFileChooserUI.this.getFileChooser().getControlButtonsAreShown());
                    } else if (s.equals("componentOrientation")) {
                        ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                        JFileChooser cc = (JFileChooser)e.getSource();
                        if (o != e.getOldValue()) {
                            cc.applyComponentOrientation(o);
                        }
                        if (LipstikFileChooserUI.this.detailsTable != null) {
                            LipstikFileChooserUI.this.detailsTable.setComponentOrientation(o);
                            LipstikFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(o);
                        }
                    } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                        LipstikFileChooserUI.this.fileNameTextField.selectAll();
                        LipstikFileChooserUI.this.fileNameTextField.requestFocus();
                    }
                }
            }
        };
    }

    private void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            this.list.ensureIndexIsVisible(i);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(i, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.ensureIndexIsVisible(this.getModel().indexOf(f));
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    public void mouseClicked(MouseEvent e) {
        int index;
        if (this.list != null && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (index = this.list.locationToIndex(e.getPoint())) >= 0) {
            File f = (File)this.list.getModel().getElementAt(index);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (this.getFileChooser().isTraversable(f)) {
                this.list.clearSelection();
                this.changeDirectory(f);
            } else {
                this.getFileChooser().approveSelection();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void changeDirectory(File dir) {
        JFileChooser fc = this.getFileChooser();
        if (dir != null && File.separatorChar == '\\' && dir.getPath().endsWith(".lnk")) {
            try {
                ShellFolder linkedTo = ShellFolder.getShellFolder(dir).getLinkLocation();
                if (linkedTo == null || !fc.isTraversable(linkedTo)) {
                    return;
                }
                dir = linkedTo;
            }
            catch (FileNotFoundException ex) {
                return;
            }
        }
        fc.setCurrentDirectory(dir);
    }

    class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            File f = (File)LipstikFileChooserUI.this.directoryComboBox.getSelectedItem();
            LipstikFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = LipstikFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("ChoosableFileFilterChangedProperty")) {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop.equals("fileFilterChanged")) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                LipstikFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                LipstikFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = LipstikFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    LipstikFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return LipstikFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            return this.filters != null ? this.filters.length : 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return LipstikFileChooserUI.this.getFileChooser().getFileFilter();
            }
            return this.filters != null ? this.filters[index] : null;
        }
    }

    public static class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector(5);
        JFileChooser chooser = LipstikFileChooserUI.this.getFileChooser();
        File selectedDirectory = null;
        FileSystemView fsv = this.chooser.getFileSystemView();
        int depthLo = 0;
        int depthHi = 0;

        public DirectoryComboBoxModel() {
            File dir = LipstikFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            File canonical;
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = LipstikFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    this.depthHi = this.depthLo = this.directories.indexOf(f);
                    int j = i - 1;
                    while (j >= 0) {
                        this.directories.insertElementAt(path.get(j), this.depthLo + i - j);
                        --j;
                        ++this.depthHi;
                    }
                    break;
                }
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                System.err.println(ex);
            }
        }

        public int getDepth(int i) {
            return i >= this.depthLo && i <= this.depthHi ? i - this.depthLo : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    static class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public static IndentIcon getIndentInstance(Icon icon, int depth) {
            if (indentIcon == null) {
                indentIcon = new IndentIcon();
            }
            LipstikFileChooserUI.indentIcon.icon = icon;
            LipstikFileChooserUI.indentIcon.depth = depth;
            return indentIcon;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y - 2);
            } else {
                this.icon.paintIcon(c, g, x, y - 2);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight() - 4;
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(LipstikFileChooserUI.this.getFileChooser().getName(directory));
            Icon icon = LipstikFileChooserUI.getIcon(directory, LipstikFileChooserUI.this.fileIcon, LipstikFileChooserUI.this.getFileChooser().getFileSystemView());
            this.setIcon(IndentIcon.getIndentInstance(icon, LipstikFileChooserUI.this.directoryComboBoxModel.getDepth(index)));
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            this.setText(LipstikFileChooserUI.this.getFileChooser().getName(file));
            this.setIcon(LipstikFileChooserUI.getIcon(file, LipstikFileChooserUI.this.fileIcon, LipstikFileChooserUI.this.getFileChooser().getFileSystemView()));
            return this;
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            LipstikFileChooserUI.this.setFileSelected();
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                this.setHorizontalAlignment(10);
            } else if (column == 1 || column == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public void setValue(Object value) {
            this.setIcon(null);
            if (value instanceof File) {
                File file = (File)value;
                this.setText(this.chooser.getName(file));
                this.setIcon(LipstikFileChooserUI.getIcon(file, LipstikFileChooserUI.this.fileIcon, LipstikFileChooserUI.this.getFileChooser().getFileSystemView()));
            } else if (value != null && value instanceof Date) {
                this.setText(this.df.format((Date)value));
            } else {
                super.setValue(value);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser fc) {
            this.columnNames = new String[]{LipstikFileChooserUI.this.fileNameHeaderText, LipstikFileChooserUI.this.fileSizeHeaderText, LipstikFileChooserUI.this.fileTypeHeaderText, LipstikFileChooserUI.this.fileDateHeaderText, LipstikFileChooserUI.this.fileAttrHeaderText};
            this.chooser = fc;
            this.listModel = LipstikFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = LipstikFileChooserUI.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = LipstikFileChooserUI.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(column);
        }

        public Object getValueAt(int row, int col) {
            File f = (File)this.listModel.getElementAt(row);
            switch (col) {
                case 0: {
                    return f;
                }
                case 1: {
                    if (!f.exists() || f.isDirectory()) {
                        return null;
                    }
                    long len = f.length() >> 10;
                    if (len < 1024L) {
                        return (len == 0L ? 1L : len) + " KB";
                    }
                    if ((len >>= 10) < 1024L) {
                        return len + " MB";
                    }
                    return (len >>= 10) + " GB";
                }
                case 2: {
                    if (!f.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(f);
                }
                case 4: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    String attributes = "";
                    if (!f.canWrite()) {
                        attributes = attributes + "R";
                    }
                    if (f.isHidden()) {
                        attributes = attributes + "H";
                    }
                    return attributes;
                }
                case 3: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    long time = f.lastModified();
                    return time == 0L ? null : new Date(time);
                }
            }
            return null;
        }

        public void contentsChanged(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.fireTableDataChanged();
        }
    }

    class ViewButtonListener
    implements ActionListener {
        JFileChooser fc;

        ViewButtonListener(JFileChooser fc) {
            this.fc = fc;
        }

        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            JPanel oldViewPanel = LipstikFileChooserUI.this.currentViewPanel;
            if (b == LipstikFileChooserUI.this.detailsViewButton) {
                if (LipstikFileChooserUI.this.detailsViewPanel == null) {
                    LipstikFileChooserUI.this.detailsViewPanel = LipstikFileChooserUI.this.createDetailsView(this.fc);
                    LipstikFileChooserUI.this.detailsViewPanel.setPreferredSize(LIST_PREF_SIZE);
                }
                LipstikFileChooserUI.this.currentViewPanel = LipstikFileChooserUI.this.detailsViewPanel;
                LipstikFileChooserUI.this.listViewButton.getModel().setRollover(false);
            } else {
                LipstikFileChooserUI.this.detailsViewButton.getModel().setRollover(false);
                LipstikFileChooserUI.this.currentViewPanel = LipstikFileChooserUI.this.listViewPanel;
            }
            if (LipstikFileChooserUI.this.currentViewPanel != oldViewPanel) {
                LipstikFileChooserUI.this.centerPanel.remove(oldViewPanel);
                LipstikFileChooserUI.this.centerPanel.add((Component)LipstikFileChooserUI.this.currentViewPanel, "Center");
                LipstikFileChooserUI.this.centerPanel.revalidate();
                LipstikFileChooserUI.this.centerPanel.repaint();
            }
        }
    }
}

