/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.delegate.LipstikComboBoxButton;
import com.lipstikLF.delegate.LipstikComboBoxEditor;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class LipstikComboBoxUI
extends MetalComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new LipstikComboBoxUI();
    }

    protected ComboBoxEditor createEditor() {
        return new LipstikComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new LipstikComboPopup(this.comboBox);
    }

    protected JButton createArrowButton() {
        return new LipstikComboBoxButton(this.comboBox, this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new LipstikPropertyChangeListener();
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension size;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof LipstikComboBoxButton) {
            LipstikComboBoxButton button = (LipstikComboBoxButton)this.arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets buttonMargin = button.getMargin();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonMargin.left + buttonMargin.right;
            size.width += button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = this.getDisplaySize();
            Insets insets = this.comboBox.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width");
            size.width += insets.left + insets.right;
            size.width += buttonWidth - 2;
            size.height += insets.top + insets.bottom + 2;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected LayoutManager createLayoutManager() {
        return new LipstikComboBoxLayoutManager();
    }

    private static class LipstikComboPopup
    extends BasicComboPopup {
        private static Border LIST_BORDER = new LineBorder(LipstikLookAndFeel.getMyCurrentTheme().getBorderNormal(), 1);

        private LipstikComboPopup(JComboBox combo) {
            super(combo);
        }

        protected void configurePopup() {
            super.configurePopup();
            this.setBorder(LIST_BORDER);
        }
    }

    private class LipstikComboBoxLayoutManager
    extends MetalComboBoxUI.MetalComboBoxLayoutManager {
        private LipstikComboBoxLayoutManager() {
            super(LipstikComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            if (!cb.isEditable()) {
                super.layoutContainer(parent);
                return;
            }
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = LipstikComboBoxUI.this.getInsets();
            int buttonWidth = 15;
            int buttonHeight = height - (insets.top + insets.bottom);
            if (LipstikComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    LipstikComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    LipstikComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            Rectangle rect = LipstikComboBoxUI.this.rectangleForCurrentValue();
            if (LipstikComboBoxUI.this.editor != null) {
                LipstikComboBoxUI.this.editor.setBounds(rect);
            }
        }
    }

    private class LipstikPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private LipstikPropertyChangeListener() {
            super(LipstikComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                LipstikComboBoxButton button = (LipstikComboBoxButton)LipstikComboBoxUI.this.arrowButton;
                button.setIconOnly(LipstikComboBoxUI.this.comboBox.isEditable());
                button.setBorder(LipstikComboBoxUI.this.comboBox.isEditable() ? UIManager.getBorder("ComboBox.arrowButtonBorder") : UIManager.getBorder("Button.border"));
                LipstikComboBoxUI.this.comboBox.repaint();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                LipstikComboBoxUI.this.arrowButton.setBackground(color);
                LipstikComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                LipstikComboBoxUI.this.arrowButton.setForeground(color);
                LipstikComboBoxUI.this.listBox.setForeground(color);
            } else if (propertyName.equals("componentOrientation")) {
                if (LipstikComboBoxUI.this.editor != null) {
                    LipstikComboBoxUI.this.editor.setComponentOrientation((ComponentOrientation)e.getNewValue());
                }
                LipstikComboBoxUI.this.comboBox.setComponentOrientation((ComponentOrientation)e.getNewValue());
                LipstikComboBoxUI.this.listBox.setComponentOrientation((ComponentOrientation)e.getNewValue());
            }
        }
    }
}

