/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.theme.LipstikColorTheme;
import com.lipstikLF.util.LipstikBorderFactory;
import com.lipstikLF.util.LipstikGradients;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.plaf.basic.BasicArrowButton;

final class LipstikArrowButton
extends BasicArrowButton {
    public LipstikArrowButton(int direction) {
        super(direction);
    }

    public void paint(Graphics g) {
        boolean isEnabled = this.getParent().isEnabled();
        boolean isPressed = this.getModel().isPressed();
        LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
        Color arrowColor = isEnabled ? Color.BLACK : theme.getControlShadow();
        int w = this.getWidth();
        int h = this.getHeight();
        int arrowSize = 4;
        int bstyle = 18;
        if (isPressed) {
            Color bg = this.getBackground();
            bg = new Color(Math.max(bg.getRed() - 10, 0), Math.max(bg.getGreen() - 10, 0), Math.max(bg.getBlue() - 10, 0));
            g.setColor(bg);
            g.fillRect(1, 1, w - 2, h - 2);
            bstyle -= 2;
        } else {
            LipstikGradients.drawGradient(g, this.getBackground(), null, 2, 2, w - 3, h - 3, true);
        }
        g.setColor(theme.getControlHighlight());
        g.drawRect(0, 0, w - 1, h - 1);
        g.setColor(arrowColor);
        if (this.getDirection() == 7) {
            int startX = w - arrowSize >> 1;
            int startY = h >> 1;
            for (int line = 0; line < arrowSize; ++line) {
                g.drawLine(startX + line, startY - line, startX + line, startY + line);
            }
            LipstikBorderFactory.paintRoundBorder(g, 1, 1, w - 1, h - 2, theme, theme.getControlHighlight(), bstyle);
        } else if (this.getDirection() == 3) {
            int startX = (w - arrowSize >> 1) + arrowSize - 1;
            int startY = h >> 1;
            for (int line = 0; line < arrowSize; ++line) {
                g.drawLine(startX - line, startY - line, startX - line, startY + line);
            }
            LipstikBorderFactory.paintRoundBorder(g, 0, 1, w - 1, h - 2, theme, theme.getControlHighlight(), bstyle);
        } else if (this.getDirection() == 1) {
            int startY = 1 + (h - arrowSize) >> 1;
            int startX = w >> 1;
            for (int line = 0; line < arrowSize; ++line) {
                g.drawLine(startX - line, startY + line, startX + line, startY + line);
            }
            LipstikBorderFactory.paintRoundBorder(g, 1, 1, w - 2, h - 1, theme, theme.getControlHighlight(), bstyle);
        } else {
            int startY = (h - arrowSize >> 1) + arrowSize - 1;
            int startX = w >> 1;
            for (int line = 0; line < arrowSize; ++line) {
                g.drawLine(startX - line, startY - line, startX + line, startY - line);
            }
            LipstikBorderFactory.paintRoundBorder(g, 1, 0, w - 2, h - 1, theme, theme.getControlHighlight(), bstyle);
        }
    }
}

