/*
 * Decompiled with CFR 0.152.
 */
package cashRegister;

import cashRegister.Command;
import cashRegister.CommandsErrors;
import util.SysUtil;
import util.comPort.PortSerial;
import util.comPort.SerialPortException;

public class FiscalCommands {
    public static final int RESET_P = 1;
    public static final int RESET_C = 3;
    public static final Object instance = new Object();

    public static void isFiscalDayStarted() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(61);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        int command = instance.getCmd();
        if (command != 61 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        int ts = instance.getShort(20);
        long tl = instance.getLong(22);
        instance.reset();
        instance.setCmd(62);
        instance.addShort(ts);
        instance.addLong(tl);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        e = instance.getArray()[0] & 0xFF;
        command = instance.getCmd();
        if (command != 62 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static long getDiference() throws Exception {
        Command instance = Command.instance;
        PortSerial port = PortSerial.getInstance();
        instance.reset();
        instance.setCmd(56);
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = instance.getArray()[0] & 0xFF;
        if (Command.instance.getCmd() != 56 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
        return instance.getLong(8);
    }

    public static void plati(int tip, long value) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(51);
        instance.addLong(value);
        instance.addByte(tip);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 51 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static void platiSve() throws Exception {
        FiscalCommands.plati(2, FiscalCommands.getDiference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setTime(long time) throws Exception {
        Object object = instance;
        synchronized (object) {
            PortSerial port = PortSerial.getInstance();
            Command.instance.reset();
            Command.instance.setCmd(1);
            Command.instance.addLong(time);
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 1 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void printPeriodicalReport(long from, long to) throws Exception {
        Object object = instance;
        synchronized (object) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(90);
            instance.addLong(from);
            instance.addLong(to);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 90 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void printDailyReport() throws Exception {
        Object object = instance;
        synchronized (object) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(88);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 88 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void printCurrentStateReport() throws Exception {
        Object object = instance;
        synchronized (object) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(89);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(instance);
            port.receiveFrame(instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 89 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reset(int i) throws Exception {
        Object object = instance;
        synchronized (object) {
            block10: {
                try {
                    Command instance = Command.instance;
                    instance.reset();
                    instance.setCmd(5);
                    instance.addByte(i);
                    PortSerial port = PortSerial.getInstance();
                    port.sendFrame(instance);
                    port.receiveFrame(instance);
                    int e = Command.instance.getArray()[0] & 0xFF;
                    int command = Command.instance.getCmd();
                    if (command != 5 && command != 128 && e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                }
                catch (SerialPortException e) {
                    if (e.getMessage().indexOf("Time out") >= 0) break block10;
                    throw e;
                }
            }
            long time = System.currentTimeMillis();
            Command cmd = Command.testInstance;
            while (true) {
                if (System.currentTimeMillis() - time > 300000L) {
                    throw new Exception("ERROR");
                }
                cmd.reset();
                cmd.setCmd(101);
                try {
                    PortSerial.getInstance().sendFrame(cmd);
                }
                catch (Exception eeee) {
                    SysUtil.delay(100);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendPIB(String spib) throws Exception {
        Object object = instance;
        synchronized (object) {
            if (spib == null || spib.indexOf("null") > 0) {
                throw new Exception("Error PIB");
            }
            try {
                if (Long.parseLong(spib) <= 0L) {
                    throw new Exception("Error PIB");
                }
            }
            catch (Exception eee) {
                throw new Exception("Error PIB");
            }
            Command.instance.reset();
            Command.instance.setCmd(7);
            Command.instance.addToArray(spib.getBytes(), 0, spib.length());
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 7 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendPIBMontenegro(String spib, String id) throws Exception {
        Object object = instance;
        synchronized (object) {
            if (spib == null || spib.indexOf("null") > 0) {
                throw new Exception("Error PIB");
            }
            if (id == null || id.indexOf("null") > 0) {
                throw new Exception("Error ID");
            }
            Command.instance.reset();
            Command.instance.setCmd(7);
            switch (spib.length()) {
                case 8: {
                    spib = "-----" + spib + "   ";
                    break;
                }
                case 13: {
                    spib = String.valueOf(spib) + "   ";
                    break;
                }
                default: {
                    throw new Exception("Wrong PIB length!");
                }
            }
            Command.instance.addToArray(spib.getBytes(), 0, spib.length());
            Command.instance.addToArray(id.getBytes(), 0, id.length());
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 7 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fiscalise() throws Exception {
        Object object = instance;
        synchronized (object) {
            block10: {
                try {
                    Command.instance.reset();
                    Command.instance.setCmd(4);
                    PortSerial port = PortSerial.getInstance();
                    port.sendFrame(Command.instance);
                    port.receiveFrame(Command.instance);
                    int e = Command.instance.getArray()[0] & 0xFF;
                    int command = Command.instance.getCmd();
                    if (command != 4 && command != 128 && e != 0) {
                        CommandsErrors.instanceMain.setError(e);
                    }
                }
                catch (SerialPortException e) {
                    if (e.getMessage().indexOf("Time out") >= 0) break block10;
                    throw e;
                }
            }
            long time = System.currentTimeMillis();
            Command cmd = Command.testInstance;
            while (true) {
                if (System.currentTimeMillis() - time > 300000L) {
                    throw new Exception("ERROR");
                }
                cmd.reset();
                cmd.setCmd(101);
                try {
                    PortSerial.getInstance().sendFrame(cmd);
                }
                catch (Exception eeee) {
                    SysUtil.delay(100);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setCurrentTime() throws Exception {
        Object object = instance;
        synchronized (object) {
            Command instance = Command.instance;
            instance.reset();
            instance.setCmd(1);
            long time = System.currentTimeMillis();
            instance.addLong(time -= 946684800000L);
            PortSerial port = PortSerial.getInstance();
            port.sendFrame(Command.instance);
            port.receiveFrame(Command.instance);
            int e = Command.instance.getArray()[0] & 0xFF;
            int command = Command.instance.getCmd();
            if (command != 1 && command != 128 && e != 0) {
                CommandsErrors.instanceMain.setError(e);
            }
        }
    }

    public static final void cutPaper() throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(27);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != 27 && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }

    public static final void execCommand(int cmd) throws Exception {
        Command instance = Command.instance;
        instance.reset();
        instance.setCmd(cmd);
        PortSerial port = PortSerial.getInstance();
        port.sendFrame(instance);
        port.receiveFrame(instance);
        int e = Command.instance.getArray()[0] & 0xFF;
        int command = Command.instance.getCmd();
        if (command != cmd && command != 128 && e != 0) {
            CommandsErrors.instanceMain.setError(e);
        }
    }
}

